﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace DocumentationTest.CodeTests {
	/// <summary>
	/// Tests various uses and basterdisations of properties
	/// </summary>
	public class PropertyTests<T> {
		/// <summary>
		/// Generated get and set
		/// </summary>
		public string AutoGeneratedGetSet { get; set; }

		/// <summary>
		/// Generated only set
		/// </summary>
		public string AutoGeneratedSet { set {} }

		/// <summary>
		/// Generated only get
		/// </summary>
		public string AutoGeneratedGet { get { return string.Empty; } }

		/// <summary>
		/// Get and set not autogenerated
		/// </summary>
		public string GetAndSet {
			get { return string.Empty; }
			set {}
		}

		/// <summary>
		/// Set not autogenerated
		/// </summary>
		public string Set {
			set {}
		}

		/// <summary>
		/// Get not autogenerated
		/// </summary>
		public string Get {
			get { return string.Empty; }
		}
		
		/// <summary>
		/// Property with generic type
		/// </summary>
		public T GenericProperty { get; set; }
	}
}
